/*
 * Decompiled with CFR 0.152.
 */
package rrkm;

import java.util.Vector;

public class RRKM_Control {
    private double planck = 3.33564E-11;
    private Vector<Double> vec_reacHarmFreq = new Vector();
    private Vector<Double> vec_tranStateFreq = new Vector();
    private int pathDegeneracy;
    private double energyStart;
    private double energyStep;
    private double energyEnd;
    private double energyThreshold;
    private Vector<Double> vec_energyLevels = new Vector();
    private Vector<Double> vec_DensityOfStates_reactant = new Vector();
    private Vector<Double> vec_DensityOfStates_transition = new Vector();
    private Vector<Double> vec_SumOfStates_transition = new Vector();
    private Vector<Double> vec_rate = new Vector();
    private Vector<Vector<Double>> resultVector = new Vector();
    private boolean readyToCopyResult = new Boolean(false);

    RRKM_Control() {
    }

    public boolean getCalcStatus() {
        return this.readyToCopyResult;
    }

    public Vector<Vector<Double>> getResult() {
        if (this.readyToCopyResult) {
            this.resultVector.add(this.vec_energyLevels);
            this.resultVector.add(this.vec_DensityOfStates_reactant);
            this.resultVector.add(this.vec_DensityOfStates_transition);
            this.resultVector.add(this.vec_SumOfStates_transition);
            this.resultVector.add(this.vec_rate);
            return this.resultVector;
        }
        return null;
    }

    public void calc(Vector<Double> vec_reacHarmFreq, Vector<Double> vec_tranStateFreq, double energyStart, double energyStep, double energyEnd, double energyThreshold, int pathDegeneracy) {
        this.vec_reacHarmFreq.clear();
        this.vec_reacHarmFreq.addAll(vec_reacHarmFreq);
        this.vec_tranStateFreq.clear();
        this.vec_tranStateFreq.addAll(vec_tranStateFreq);
        this.energyStart = energyStart;
        this.energyStep = energyStep;
        this.energyEnd = energyEnd;
        this.energyThreshold = energyThreshold;
        this.pathDegeneracy = pathDegeneracy;
        this.run_calc_run();
    }

    private void run_calc_run() {
        Thread thr = new Thread(new Runnable(){

            @Override
            public void run() {
                RRKM_Control.this.readyToCopyResult = false;
                this.setEnergyLevel();
                RRKM_Control.this.vec_DensityOfStates_reactant = this.calculateDensityOfStates(RRKM_Control.this.vec_reacHarmFreq, RRKM_Control.this.vec_DensityOfStates_reactant);
                RRKM_Control.this.vec_DensityOfStates_transition = this.calculateDensityOfStates(RRKM_Control.this.vec_tranStateFreq, RRKM_Control.this.vec_DensityOfStates_transition);
                RRKM_Control.this.vec_SumOfStates_transition = this.calculateSumOfStates(RRKM_Control.this.vec_DensityOfStates_transition, RRKM_Control.this.vec_SumOfStates_transition);
                this.calculatekE();
                RRKM_Control.this.readyToCopyResult = true;
            }

            private void setEnergyLevel() {
                RRKM_Control.this.vec_energyLevels.clear();
                RRKM_Control.this.vec_DensityOfStates_reactant.clear();
                RRKM_Control.this.vec_DensityOfStates_transition.clear();
                RRKM_Control.this.vec_SumOfStates_transition.clear();
                RRKM_Control.this.vec_rate.clear();
                int i = 0;
                while ((double)i <= RRKM_Control.this.energyEnd) {
                    RRKM_Control.this.vec_energyLevels.add(Double.valueOf(i));
                    RRKM_Control.this.vec_rate.add(0.0);
                    RRKM_Control.this.vec_DensityOfStates_reactant.add(0.0);
                    RRKM_Control.this.vec_DensityOfStates_transition.add(0.0);
                    ++i;
                }
                RRKM_Control.this.vec_DensityOfStates_reactant.set(0, 1.0);
                RRKM_Control.this.vec_DensityOfStates_transition.set(0, 1.0);
            }

            private Vector<Double> calculateDensityOfStates(Vector<Double> freqs, Vector<Double> result) {
                int i = 0;
                while (i < freqs.size()) {
                    int j;
                    int k = j = freqs.get(i).intValue();
                    while ((double)k <= RRKM_Control.this.energyEnd) {
                        double tmp2 = result.get(k) + result.get(k - j);
                        result.set(k, tmp2);
                        ++k;
                    }
                    ++i;
                }
                return result;
            }

            private Vector<Double> calculateSumOfStates(Vector<Double> density, Vector<Double> result) {
                result.add(density.get(0));
                int i = 1;
                while (i < density.size()) {
                    double tmp = density.get(i) + result.get(i - 1);
                    result.add(tmp);
                    ++i;
                }
                return result;
            }

            private void calculatekE() {
                int correct = (int)RRKM_Control.this.energyThreshold;
                int i = 0;
                while (i < RRKM_Control.this.vec_energyLevels.size()) {
                    if (!((Double)RRKM_Control.this.vec_energyLevels.get(i) < RRKM_Control.this.energyThreshold)) {
                        int tmpIndex = i - correct;
                        double tmp = (double)RRKM_Control.this.pathDegeneracy * (Double)RRKM_Control.this.vec_SumOfStates_transition.get(tmpIndex) / (RRKM_Control.this.planck * (Double)RRKM_Control.this.vec_DensityOfStates_reactant.get(i));
                        RRKM_Control.this.vec_rate.set(i, tmp);
                    }
                    ++i;
                }
            }
        });
        thr.start();
    }
}

