/*
 * Decompiled with CFR 0.152.
 */
package rrkm;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.table.DefaultTableModel;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import rrkm.RRKM_Control;
import rrkm.RRKM_EnergyCaretListener;
import rrkm.RRKM_TableKeyListener;
import rrkm.Tab_Graphical_Output_Panel;
import rrkm.Tab_Tabular_Output_Panel;
import rrkm.Tool_AdapterSpreadsheet;

public class Tab_Input_Panel
extends JPanel {
    private static final long serialVersionUID = -1859217481264915128L;
    private RRKM_Control control;
    private JPanel panel_molName;
    private JTextField textField_molName;
    private JPanel panel_hint;
    private JPanel panel_reacFreq;
    private JTable table_reactantHarmonicFrequencies = new JTable();
    private DefaultTableModel tm_reac;
    private Vector<Double> vec_reacHarmFreq = new Vector();
    private JLabel label_numberOfHarmonic;
    private JPanel panel_tranFreq;
    private JTable table_transitionStateFrequencies = new JTable();
    private DefaultTableModel tm_tran;
    private Vector<Double> vec_tranStateFreq = new Vector();
    private JLabel label_numberOfTransition;
    private JPanel panel_energy;
    private Tab_Tabular_Output_Panel panel_tab_output;
    private Tab_Graphical_Output_Panel panel_graph_output;
    JTextField[] energy = new JTextField[]{new JTextField(), new JTextField(), new JTextField(), new JTextField(), new JTextField(), new JTextField()};
    private JButton button_calculate = new JButton("Calculate!");
    private double energyStart;
    private double energyStep;
    private double energyEnd;
    private double energyThreshold;
    private int pathDegeneracy;
    boolean allowCalc;
    StringBuffer failureText = new StringBuffer();
    private Timer getResultTimer;
    private Vector<Vector<Double>> resultVector = new Vector();

    public Tab_Input_Panel(RRKM_Control control, Tab_Tabular_Output_Panel panel_tab_output, Tab_Graphical_Output_Panel panel_graph_output) {
        this.control = control;
        this.panel_tab_output = panel_tab_output;
        this.panel_graph_output = panel_graph_output;
        GridBagLayout bgl_panel_input = new GridBagLayout();
        bgl_panel_input.columnWeights = new double[]{0.0, 0.0, 0.0};
        bgl_panel_input.rowWeights = new double[]{0.0, 0.0};
        this.setLayout(bgl_panel_input);
        this.init_panel_molName();
        this.init_panel_hint();
        this.init_panel_reacFreq();
        this.init_panel_tranFreq();
        this.init_panel_energy();
    }

    private void init_panel_molName() {
        this.panel_molName = new JPanel();
        GridBagConstraints gbc_panel_molName = new GridBagConstraints();
        gbc_panel_molName.ipady = 15;
        gbc_panel_molName.ipadx = 15;
        gbc_panel_molName.fill = 1;
        gbc_panel_molName.anchor = 11;
        gbc_panel_molName.gridwidth = 2;
        gbc_panel_molName.gridx = 0;
        gbc_panel_molName.gridy = 0;
        this.add((Component)this.panel_molName, gbc_panel_molName);
        GridBagLayout gbl_panel_molName = new GridBagLayout();
        gbl_panel_molName.columnWeights = new double[]{0.0, 0.0};
        gbl_panel_molName.rowWeights = new double[]{0.0};
        this.panel_molName.setLayout(gbl_panel_molName);
        JLabel label_nameOfMolecule = new JLabel("Name of Molecule:");
        GridBagConstraints gbc_label_nameOfMolecule = new GridBagConstraints();
        gbc_label_nameOfMolecule.ipadx = 10;
        gbc_label_nameOfMolecule.anchor = 13;
        gbc_label_nameOfMolecule.insets = new Insets(0, 15, 0, 0);
        gbc_label_nameOfMolecule.gridx = 0;
        gbc_label_nameOfMolecule.gridy = 0;
        this.panel_molName.add((Component)label_nameOfMolecule, gbc_label_nameOfMolecule);
        label_nameOfMolecule.setHorizontalAlignment(2);
        this.textField_molName = new JTextField();
        GridBagConstraints gbc_textField_molName = new GridBagConstraints();
        gbc_textField_molName.weightx = 1.0;
        gbc_textField_molName.fill = 2;
        gbc_textField_molName.gridx = 1;
        gbc_textField_molName.gridy = 0;
        this.panel_molName.add((Component)this.textField_molName, gbc_textField_molName);
        this.textField_molName.setToolTipText("Type in the name of your molecule");
        this.textField_molName.setColumns(44);
    }

    private void init_panel_hint() {
        this.panel_hint = new JPanel();
        GridBagConstraints gbc_panel_hint = new GridBagConstraints();
        gbc_panel_hint.ipady = 15;
        gbc_panel_hint.ipadx = 15;
        gbc_panel_hint.fill = 1;
        gbc_panel_hint.anchor = 11;
        gbc_panel_hint.gridwidth = 2;
        gbc_panel_hint.gridx = 2;
        gbc_panel_hint.gridy = 0;
        this.add((Component)this.panel_hint, gbc_panel_hint);
        GridBagLayout gbl_panel_hint = new GridBagLayout();
        this.panel_hint.setLayout(gbl_panel_hint);
        String label = "all input in cm\u207b\u00b9";
        JLabel label_hint = new JLabel(label);
        GridBagConstraints gbc_label_hint = new GridBagConstraints();
        gbc_label_hint.anchor = 13;
        gbc_label_hint.gridx = 0;
        gbc_label_hint.gridy = 0;
        this.panel_hint.add((Component)label_hint, gbc_label_hint);
    }

    private void init_panel_reacFreq() {
        this.panel_reacFreq = new JPanel();
        GridBagConstraints gbc_panel_reacFreq = new GridBagConstraints();
        gbc_panel_reacFreq.insets = new Insets(0, 15, 0, 15);
        gbc_panel_reacFreq.weighty = 1.0;
        gbc_panel_reacFreq.weightx = 1.0;
        gbc_panel_reacFreq.anchor = 18;
        gbc_panel_reacFreq.fill = 1;
        gbc_panel_reacFreq.gridx = 0;
        gbc_panel_reacFreq.gridy = 1;
        this.add((Component)this.panel_reacFreq, gbc_panel_reacFreq);
        GridBagLayout gbl_panel_reacFreq = new GridBagLayout();
        gbl_panel_reacFreq.columnWeights = new double[]{0.0, 0.0};
        gbl_panel_reacFreq.rowWeights = new double[]{0.0, 0.0};
        this.panel_reacFreq.setLayout(gbl_panel_reacFreq);
        JButton addReacHarmFreqLine = new JButton("insert line");
        addReacHarmFreqLine.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Tab_Input_Panel.this.insertLineBeforeSelected(Tab_Input_Panel.this.table_reactantHarmonicFrequencies, Tab_Input_Panel.this.tm_reac);
            }
        });
        GridBagConstraints gbc_addReacHarmFreqLine = new GridBagConstraints();
        gbc_addReacHarmFreqLine.gridx = 0;
        gbc_addReacHarmFreqLine.anchor = 17;
        gbc_addReacHarmFreqLine.gridy = 0;
        gbc_addReacHarmFreqLine.insets = new Insets(0, 40, 0, 0);
        this.panel_reacFreq.add((Component)addReacHarmFreqLine, gbc_addReacHarmFreqLine);
        JButton removeReacHarmFreqLine = new JButton("remove selected line");
        removeReacHarmFreqLine.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Tab_Input_Panel.this.removeSelectedLine(Tab_Input_Panel.this.table_reactantHarmonicFrequencies, Tab_Input_Panel.this.tm_reac);
            }
        });
        GridBagConstraints gbc_removeReacHarmFreqLine = new GridBagConstraints();
        gbc_removeReacHarmFreqLine.gridx = 0;
        gbc_removeReacHarmFreqLine.gridy = 0;
        gbc_removeReacHarmFreqLine.insets = new Insets(0, 110, 0, 0);
        this.panel_reacFreq.add((Component)removeReacHarmFreqLine, gbc_removeReacHarmFreqLine);
        this.table_reactantHarmonicFrequencies.setModel(new DefaultTableModel(new Object[][]{new Object[1]}, new String[]{"Reactant Harmonic Frequencies"}));
        this.tm_reac = (DefaultTableModel)this.table_reactantHarmonicFrequencies.getModel();
        this.table_reactantHarmonicFrequencies.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.table_reactantHarmonicFrequencies.addKeyListener(new RRKM_TableKeyListener(this.table_reactantHarmonicFrequencies));
        new Tool_AdapterSpreadsheet(this.table_reactantHarmonicFrequencies);
        JScrollPane scrollPane_reacHarmFreq = new JScrollPane(this.table_reactantHarmonicFrequencies);
        scrollPane_reacHarmFreq.setPreferredSize(new Dimension(180, 400));
        GridBagConstraints gbc_scrollPane_reacHarmFreq = new GridBagConstraints();
        gbc_scrollPane_reacHarmFreq.weightx = 1.0;
        gbc_scrollPane_reacHarmFreq.weighty = 1.0;
        gbc_scrollPane_reacHarmFreq.fill = 1;
        gbc_scrollPane_reacHarmFreq.anchor = 11;
        gbc_scrollPane_reacHarmFreq.gridx = 0;
        gbc_scrollPane_reacHarmFreq.gridy = 1;
        this.panel_reacFreq.add((Component)scrollPane_reacHarmFreq, gbc_scrollPane_reacHarmFreq);
        this.label_numberOfHarmonic = new JLabel("     ");
        GridBagConstraints gbc_label_numberOfHarmonic = new GridBagConstraints();
        gbc_label_numberOfHarmonic.anchor = 17;
        gbc_label_numberOfHarmonic.gridx = 0;
        gbc_label_numberOfHarmonic.gridy = 2;
        this.panel_reacFreq.add((Component)this.label_numberOfHarmonic, gbc_label_numberOfHarmonic);
    }

    private void init_panel_tranFreq() {
        this.panel_tranFreq = new JPanel();
        GridBagConstraints gbc_panel_tranFreq = new GridBagConstraints();
        gbc_panel_tranFreq.weightx = 1.0;
        gbc_panel_tranFreq.anchor = 11;
        gbc_panel_tranFreq.fill = 1;
        gbc_panel_tranFreq.gridx = 1;
        gbc_panel_tranFreq.gridy = 1;
        this.add((Component)this.panel_tranFreq, gbc_panel_tranFreq);
        GridBagLayout gbl_panel_tranFreq = new GridBagLayout();
        gbl_panel_tranFreq.columnWeights = new double[]{0.0};
        gbl_panel_tranFreq.rowWeights = new double[]{0.0, 0.0};
        this.panel_tranFreq.setLayout(gbl_panel_tranFreq);
        JButton addTranFreqLine = new JButton("insert line");
        addTranFreqLine.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Tab_Input_Panel.this.insertLineBeforeSelected(Tab_Input_Panel.this.table_transitionStateFrequencies, Tab_Input_Panel.this.tm_tran);
            }
        });
        GridBagConstraints gbc_addTranFreqLine = new GridBagConstraints();
        gbc_addTranFreqLine.gridx = 0;
        gbc_addTranFreqLine.anchor = 17;
        gbc_addTranFreqLine.gridy = 0;
        gbc_addTranFreqLine.insets = new Insets(0, 40, 0, 0);
        this.panel_tranFreq.add((Component)addTranFreqLine, gbc_addTranFreqLine);
        JButton removeTranFreqLine = new JButton("remove selected line");
        removeTranFreqLine.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Tab_Input_Panel.this.removeSelectedLine(Tab_Input_Panel.this.table_transitionStateFrequencies, Tab_Input_Panel.this.tm_tran);
            }
        });
        GridBagConstraints gbc_removeTranFreqLine = new GridBagConstraints();
        gbc_removeTranFreqLine.gridx = 0;
        gbc_removeTranFreqLine.gridy = 0;
        gbc_removeTranFreqLine.insets = new Insets(0, 110, 0, 0);
        this.panel_tranFreq.add((Component)removeTranFreqLine, gbc_removeTranFreqLine);
        this.table_transitionStateFrequencies = new JTable();
        this.table_transitionStateFrequencies.setCellSelectionEnabled(true);
        this.table_transitionStateFrequencies.setColumnSelectionAllowed(true);
        this.table_transitionStateFrequencies.setSelectionMode(1);
        this.table_transitionStateFrequencies.setModel(new DefaultTableModel(new Object[][]{new Object[1]}, new String[]{"Transition State Frequencies"}));
        this.tm_tran = (DefaultTableModel)this.table_transitionStateFrequencies.getModel();
        this.table_transitionStateFrequencies.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.table_transitionStateFrequencies.addKeyListener(new RRKM_TableKeyListener(this.table_transitionStateFrequencies));
        new Tool_AdapterSpreadsheet(this.table_transitionStateFrequencies);
        JScrollPane scrollPane_transStateFreq = new JScrollPane(this.table_transitionStateFrequencies);
        scrollPane_transStateFreq.setPreferredSize(new Dimension(180, 400));
        GridBagConstraints gbc_scrollPane_transStateFreq = new GridBagConstraints();
        gbc_scrollPane_transStateFreq.weightx = 1.0;
        gbc_scrollPane_transStateFreq.weighty = 1.0;
        gbc_scrollPane_transStateFreq.fill = 1;
        gbc_scrollPane_transStateFreq.anchor = 18;
        gbc_scrollPane_transStateFreq.gridx = 0;
        gbc_scrollPane_transStateFreq.gridy = 1;
        this.panel_tranFreq.add((Component)scrollPane_transStateFreq, gbc_scrollPane_transStateFreq);
        this.label_numberOfTransition = new JLabel("    ");
        GridBagConstraints gbc_label_numberOfTransition = new GridBagConstraints();
        gbc_label_numberOfTransition.anchor = 17;
        gbc_label_numberOfTransition.gridx = 0;
        gbc_label_numberOfTransition.gridy = 2;
        this.panel_tranFreq.add((Component)this.label_numberOfTransition, gbc_label_numberOfTransition);
    }

    private void init_panel_energy() {
        this.panel_energy = new JPanel();
        GridBagConstraints gbc_panel_energy = new GridBagConstraints();
        gbc_panel_energy.insets = new Insets(0, 15, 0, 15);
        gbc_panel_energy.anchor = 11;
        gbc_panel_energy.fill = 1;
        gbc_panel_energy.gridx = 2;
        gbc_panel_energy.gridy = 1;
        this.add((Component)this.panel_energy, gbc_panel_energy);
        GridBagLayout gbl_panel_energy = new GridBagLayout();
        gbl_panel_energy.columnWeights = new double[]{1.0};
        gbl_panel_energy.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        this.panel_energy.setLayout(gbl_panel_energy);
        JLabel label_energyStart = new JLabel("Starting Energy:");
        GridBagConstraints gbc_label_energyStart = new GridBagConstraints();
        gbc_label_energyStart.insets = new Insets(0, 0, 5, 0);
        gbc_label_energyStart.anchor = 15;
        gbc_label_energyStart.fill = 1;
        gbc_label_energyStart.gridx = 0;
        gbc_label_energyStart.gridy = 0;
        this.panel_energy.add((Component)label_energyStart, gbc_label_energyStart);
        this.energy[0].addCaretListener(new RRKM_EnergyCaretListener(this.energy));
        GridBagConstraints gbc_textField_energyStart = new GridBagConstraints();
        gbc_textField_energyStart.fill = 1;
        gbc_textField_energyStart.insets = new Insets(0, 0, 20, 0);
        gbc_textField_energyStart.gridx = 0;
        gbc_textField_energyStart.gridy = 1;
        this.panel_energy.add((Component)this.energy[0], gbc_textField_energyStart);
        this.energy[0].setColumns(10);
        JLabel label_energyStep = new JLabel("Step Width:");
        GridBagConstraints gbc_label_energyStep = new GridBagConstraints();
        gbc_label_energyStep.insets = new Insets(0, 0, 5, 0);
        gbc_label_energyStep.fill = 1;
        gbc_label_energyStep.gridx = 0;
        gbc_label_energyStep.gridy = 2;
        this.panel_energy.add((Component)label_energyStep, gbc_label_energyStep);
        this.energy[1].addCaretListener(new RRKM_EnergyCaretListener(this.energy));
        GridBagConstraints gbc_textField_energyStep = new GridBagConstraints();
        gbc_textField_energyStep.fill = 1;
        gbc_textField_energyStep.insets = new Insets(0, 0, 20, 0);
        gbc_textField_energyStep.gridx = 0;
        gbc_textField_energyStep.gridy = 3;
        this.panel_energy.add((Component)this.energy[1], gbc_textField_energyStep);
        this.energy[1].setColumns(10);
        JLabel label_energyEnd = new JLabel("Ending Energy:");
        GridBagConstraints gbc_label_energyEnd = new GridBagConstraints();
        gbc_label_energyEnd.insets = new Insets(0, 0, 5, 0);
        gbc_label_energyEnd.fill = 1;
        gbc_label_energyEnd.gridx = 0;
        gbc_label_energyEnd.gridy = 4;
        this.panel_energy.add((Component)label_energyEnd, gbc_label_energyEnd);
        this.energy[2].addCaretListener(new RRKM_EnergyCaretListener(this.energy));
        GridBagConstraints gbc_textField_energyEnd = new GridBagConstraints();
        gbc_textField_energyEnd.fill = 1;
        gbc_textField_energyEnd.insets = new Insets(0, 0, 20, 0);
        gbc_textField_energyEnd.gridx = 0;
        gbc_textField_energyEnd.gridy = 5;
        this.panel_energy.add((Component)this.energy[2], gbc_textField_energyEnd);
        this.energy[2].setColumns(10);
        JLabel label_numberOfSteps = new JLabel("Number of Steps:");
        GridBagConstraints gbc_label_numberOfSteps = new GridBagConstraints();
        gbc_label_numberOfSteps.insets = new Insets(0, 0, 5, 0);
        gbc_label_numberOfSteps.fill = 1;
        gbc_label_numberOfSteps.gridx = 0;
        gbc_label_numberOfSteps.gridy = 6;
        this.panel_energy.add((Component)label_numberOfSteps, gbc_label_numberOfSteps);
        this.energy[3].setEditable(false);
        GridBagConstraints gbc_textField_numberOfSteps = new GridBagConstraints();
        gbc_textField_numberOfSteps.insets = new Insets(0, 0, 20, 0);
        gbc_textField_numberOfSteps.fill = 2;
        gbc_textField_numberOfSteps.gridx = 0;
        gbc_textField_numberOfSteps.gridy = 7;
        this.panel_energy.add((Component)this.energy[3], gbc_textField_numberOfSteps);
        this.energy[3].setColumns(10);
        JLabel label_energyThreshold = new JLabel("Threshold Energy:");
        GridBagConstraints gbc_label_energyThreshold = new GridBagConstraints();
        gbc_label_energyThreshold.insets = new Insets(0, 0, 5, 0);
        gbc_label_energyThreshold.fill = 1;
        gbc_label_energyThreshold.gridx = 0;
        gbc_label_energyThreshold.gridy = 8;
        this.panel_energy.add((Component)label_energyThreshold, gbc_label_energyThreshold);
        GridBagConstraints gbc_textField_energyThreshold = new GridBagConstraints();
        gbc_textField_energyThreshold.anchor = 11;
        gbc_textField_energyThreshold.fill = 2;
        gbc_textField_energyThreshold.insets = new Insets(0, 0, 20, 0);
        gbc_textField_energyThreshold.gridx = 0;
        gbc_textField_energyThreshold.gridy = 9;
        this.panel_energy.add((Component)this.energy[4], gbc_textField_energyThreshold);
        this.energy[4].setColumns(10);
        JLabel label_pathDegeneracy = new JLabel("Path degeneracy:");
        GridBagConstraints gbc_label_pathDegeneracy = new GridBagConstraints();
        gbc_label_pathDegeneracy.insets = new Insets(0, 0, 5, 0);
        gbc_label_pathDegeneracy.fill = 1;
        gbc_label_pathDegeneracy.gridx = 0;
        gbc_label_pathDegeneracy.gridy = 10;
        this.panel_energy.add((Component)label_pathDegeneracy, gbc_label_pathDegeneracy);
        GridBagConstraints gbc_textField_pathDegeneracy = new GridBagConstraints();
        gbc_textField_pathDegeneracy.anchor = 11;
        gbc_textField_pathDegeneracy.fill = 2;
        gbc_textField_pathDegeneracy.weighty = 1.0;
        gbc_textField_pathDegeneracy.insets = new Insets(0, 0, 20, 0);
        gbc_textField_pathDegeneracy.gridx = 0;
        gbc_textField_pathDegeneracy.gridy = 11;
        this.panel_energy.add((Component)this.energy[5], gbc_textField_pathDegeneracy);
        this.energy[5].setColumns(10);
        this.button_calculate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Tab_Input_Panel.this.start_calc();
            }
        });
        GridBagConstraints gbc_button_calculate = new GridBagConstraints();
        gbc_button_calculate.fill = 2;
        gbc_button_calculate.insets = new Insets(0, 0, 15, 0);
        gbc_button_calculate.gridx = 0;
        gbc_button_calculate.gridy = 12;
        this.panel_energy.add((Component)this.button_calculate, gbc_button_calculate);
    }

    private boolean validate_input() {
        this.allowCalc = true;
        this.failureText.delete(0, this.failureText.length());
        this.failureText.append("<html><p>Please check your input at:</p><ul>");
        this.vec_reacHarmFreq.removeAllElements();
        this.validate_table(this.tm_reac, this.vec_reacHarmFreq, this.failureText, "reactant");
        this.vec_tranStateFreq.removeAllElements();
        this.validate_table(this.tm_tran, this.vec_tranStateFreq, this.failureText, "transition state");
        try {
            this.energyStart = Double.parseDouble(this.energy[0].getText());
        }
        catch (Exception e) {
            this.allowCalc = false;
            this.failureText.append("<li>Starting Energy</li>");
            this.energy[0].setText("");
        }
        try {
            this.energyStep = Double.parseDouble(this.energy[1].getText());
        }
        catch (Exception e) {
            this.allowCalc = false;
            this.failureText.append("<li>Energy Step</li>");
            this.energy[1].setText("");
        }
        try {
            this.energyEnd = Double.parseDouble(this.energy[2].getText());
        }
        catch (Exception e) {
            this.allowCalc = false;
            this.failureText.append("<li>Ending Energy</li>");
            this.energy[2].setText("");
        }
        try {
            this.energyThreshold = Double.parseDouble(this.energy[4].getText());
        }
        catch (Exception e) {
            this.allowCalc = false;
            this.failureText.append("<li>Threshold Energy</li>");
            this.energy[4].setText("");
        }
        try {
            this.pathDegeneracy = Integer.parseInt(this.energy[5].getText());
        }
        catch (Exception e) {
            this.allowCalc = false;
            this.failureText.append("<li>Path degeneracy</li>");
            this.energy[5].setText("");
        }
        if (this.energyEnd < this.energyStart) {
            this.failureText.append("<li>Ending Energy to small for Starting Energy</li>");
            this.allowCalc = false;
        }
        if (this.vec_reacHarmFreq.size() != this.vec_tranStateFreq.size() + 1) {
            this.failureText.append("<li>Quantities of Frequencies not correct! <br/ ># Reactant Frequencies = # Transition State Frequencies + 1</li>");
            this.allowCalc = false;
        }
        this.failureText.append("</ul></html>");
        if (!this.allowCalc) {
            GridBagLayout gbl_warningsLayout = new GridBagLayout();
            final JDialog dialog = new JDialog();
            dialog.setLayout(gbl_warningsLayout);
            GridBagConstraints gbc_warningsText = new GridBagConstraints();
            gbc_warningsText.gridx = 0;
            gbc_warningsText.gridy = 0;
            gbc_warningsText.weightx = 1.0;
            gbc_warningsText.insets = new Insets(10, 10, 10, 10);
            JLabel warningsText = new JLabel(this.failureText.toString());
            JButton close = new JButton("OK");
            GridBagConstraints gbc_closeButton = new GridBagConstraints();
            gbc_closeButton.gridx = 0;
            gbc_closeButton.gridy = 1;
            gbc_closeButton.insets = new Insets(10, 10, 10, 10);
            close.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    dialog.dispose();
                }
            });
            dialog.add((Component)warningsText, gbc_warningsText);
            dialog.add((Component)close, gbc_closeButton);
            dialog.setTitle("Input Error!");
            dialog.pack();
            dialog.setLocationRelativeTo(null);
            dialog.setDefaultCloseOperation(2);
            dialog.setVisible(true);
        }
        return this.allowCalc;
    }

    private void insertLineBeforeSelected(JTable table, DefaultTableModel tm) {
        if (table.getSelectedRow() == -1) {
            tm.insertRow(0, new String[tm.getColumnCount()]);
        } else {
            tm.insertRow(table.getSelectedRow(), new String[tm.getColumnCount()]);
        }
    }

    private void removeSelectedLine(JTable table, DefaultTableModel tm) {
        tm.removeRow(table.getSelectedRow());
        if (tm.getRowCount() == 0) {
            tm.insertRow(0, new String[tm.getColumnCount()]);
        }
    }

    private void validate_table(DefaultTableModel tm, Vector<Double> vec, StringBuffer failureText, String nameOfTable) {
        this.failureText = failureText;
        int i = 0;
        while (i < tm.getRowCount()) {
            try {
                if (tm.getValueAt(i, 0) == null && tm.getRowCount() != 1) {
                    tm.removeRow(i);
                    --i;
                } else {
                    double tmp = Double.parseDouble((String)tm.getValueAt(i, 0));
                    if (tmp >= 0.0) {
                        vec.add(tmp);
                    } else if (tm.getRowCount() != 1) {
                        tm.removeRow(i);
                        --i;
                    } else {
                        tm.setValueAt(null, i, 0);
                    }
                }
            }
            catch (Exception e) {
                this.allowCalc = false;
                failureText.append("<li>frequencies of " + nameOfTable + "</li>");
                if (tm.getRowCount() != 1) {
                    tm.removeRow(i);
                    --i;
                }
                tm.setValueAt(null, i, 0);
            }
            ++i;
        }
    }

    public String getMolName() {
        if (this.textField_molName.getText() != "") {
            return this.textField_molName.getText();
        }
        return "noMolName";
    }

    public void start_calc() {
        if (this.validate_input()) {
            this.button_calculate.setEnabled(false);
            this.control.calc(this.vec_reacHarmFreq, this.vec_tranStateFreq, this.energyStart, this.energyStep, this.energyEnd, this.energyThreshold, this.pathDegeneracy);
            this.getResultTimer = new Timer(100, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    if (Tab_Input_Panel.this.control.getCalcStatus()) {
                        Tab_Input_Panel.this.resultVector = Tab_Input_Panel.this.control.getResult();
                        Tab_Input_Panel.this.panel_graph_output.setResultVector(Tab_Input_Panel.this.resultVector, Double.parseDouble(Tab_Input_Panel.this.energy[0].getText()), Double.parseDouble(Tab_Input_Panel.this.energy[1].getText()), Double.parseDouble(Tab_Input_Panel.this.energy[4].getText()));
                        Tab_Input_Panel.this.panel_tab_output.setResultVector(Tab_Input_Panel.this.resultVector, Double.parseDouble(Tab_Input_Panel.this.energy[0].getText()), Double.parseDouble(Tab_Input_Panel.this.energy[1].getText()), Double.parseDouble(Tab_Input_Panel.this.energy[4].getText()));
                        Tab_Input_Panel.this.killTimer();
                        Tab_Input_Panel.this.button_calculate.setEnabled(true);
                        ((JTabbedPane)Tab_Input_Panel.this.getParent()).setSelectedComponent(Tab_Input_Panel.this.panel_tab_output);
                    }
                }
            });
            this.getResultTimer.start();
        }
    }

    private void killTimer() {
        this.getResultTimer.stop();
    }

    public void clearInput() {
        this.textField_molName.setText("");
        this.energy[0].setText("");
        this.energy[1].setText("");
        this.energy[2].setText("");
        this.energy[3].setText("");
        this.energy[4].setText("");
        this.energy[5].setText("");
        DefaultTableModel reac_tm = (DefaultTableModel)this.table_reactantHarmonicFrequencies.getModel();
        reac_tm.setRowCount(1);
        reac_tm.setValueAt("", 0, 0);
        DefaultTableModel tran_tm = (DefaultTableModel)this.table_transitionStateFrequencies.getModel();
        tran_tm.setRowCount(1);
        tran_tm.setValueAt("", 0, 0);
    }

    private void createTableRows(Element xmlTable, JTable table) {
        DefaultTableModel tm = (DefaultTableModel)table.getModel();
        int i = 0;
        while (i < tm.getRowCount()) {
            StringBuffer rowBuffer = new StringBuffer();
            int j = 0;
            while (j < tm.getColumnCount()) {
                if (j == tm.getColumnCount() - 1) {
                    rowBuffer.append(tm.getValueAt(i, j));
                } else {
                    rowBuffer.append(tm.getValueAt(i, j) + ";");
                }
                ++j;
            }
            xmlTable.addContent((Content)new Element("row").setText(rowBuffer.toString()));
            ++i;
        }
    }

    private void readTableRows(Element root, JTable table, String xmlTableName) {
        DefaultTableModel tm = (DefaultTableModel)table.getModel();
        Element xmlTable = root.getChild(xmlTableName);
        List tableData = xmlTable.getChildren("row");
        int i = 0;
        while (i < tableData.size()) {
            Element node = (Element)tableData.get(i);
            String[] cellData = node.getText().split(";");
            int colCount = cellData.length;
            tm.addRow(new String[colCount]);
            int j = 0;
            while (j < cellData.length) {
                tm.setValueAt(cellData[j], i, j);
                ++j;
            }
            ++i;
        }
    }

    public void open() {
        SAXBuilder builder = new SAXBuilder();
        JFileChooser filechooser = new JFileChooser();
        filechooser.showOpenDialog(this.getParent());
        File xmlFile = null;
        if (filechooser.getSelectedFile() != null) {
            xmlFile = filechooser.getSelectedFile();
        }
        try {
            Document document = builder.build(xmlFile);
            Element rootNode = document.getRootElement();
            this.textField_molName.setText(rootNode.getAttributeValue("name"));
            this.energy[0].setText(rootNode.getChild("energyStart").getAttributeValue("value"));
            this.energy[1].setText(rootNode.getChild("energyStep").getAttributeValue("value"));
            this.energy[2].setText(rootNode.getChild("energyEnd").getAttributeValue("value"));
            this.energy[2].setCaretPosition(0);
            this.energy[4].setText(rootNode.getChild("energyThreshold").getAttributeValue("value"));
            this.energy[5].setText(rootNode.getChild("pathDegeneracy").getAttributeValue("value"));
            this.readTableRows(rootNode, this.table_reactantHarmonicFrequencies, "table_reacHarmFreq");
            this.readTableRows(rootNode, this.table_transitionStateFrequencies, "table_tranStateFreq");
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    public void saveInputAs() {
        try {
            Element inputvalues = new Element("inputvalues");
            inputvalues.setAttribute(new Attribute("name", this.textField_molName.getText()));
            Document doc = new Document(inputvalues);
            Element energyStart = new Element("energyStart");
            energyStart.setAttribute(new Attribute("value", this.energy[0].getText()));
            doc.getRootElement().addContent((Content)energyStart);
            Element energyStep = new Element("energyStep");
            energyStep.setAttribute(new Attribute("value", this.energy[1].getText()));
            doc.getRootElement().addContent((Content)energyStep);
            Element energyEnd = new Element("energyEnd");
            energyEnd.setAttribute(new Attribute("value", this.energy[2].getText()));
            doc.getRootElement().addContent((Content)energyEnd);
            Element energyThreshold = new Element("energyThreshold");
            energyThreshold.setAttribute(new Attribute("value", this.energy[4].getText()));
            doc.getRootElement().addContent((Content)energyThreshold);
            Element pathDegeneracy = new Element("pathDegeneracy");
            pathDegeneracy.setAttribute(new Attribute("value", this.energy[5].getText()));
            doc.getRootElement().addContent((Content)pathDegeneracy);
            Element table_reacHarmFreq = new Element("table_reacHarmFreq");
            table_reacHarmFreq.setAttribute(new Attribute("name", "reacHarmFreq"));
            doc.getRootElement().addContent((Content)table_reacHarmFreq);
            this.createTableRows(table_reacHarmFreq, this.table_reactantHarmonicFrequencies);
            Element table_tranStateFreq = new Element("table_tranStateFreq");
            table_tranStateFreq.setAttribute(new Attribute("name", "tranStateFreq"));
            doc.getRootElement().addContent((Content)table_tranStateFreq);
            this.createTableRows(table_tranStateFreq, this.table_transitionStateFrequencies);
            XMLOutputter xmlOutput = new XMLOutputter();
            xmlOutput.setFormat(Format.getPrettyFormat());
            JFileChooser filechooser = new JFileChooser();
            filechooser.setSelectedFile(new File(String.valueOf(this.textField_molName.getText()) + "_inputData.xml"));
            filechooser.showSaveDialog(this.getParent());
            if (filechooser.getSelectedFile() != null) {
                FileWriter writer = new FileWriter(filechooser.getSelectedFile());
                xmlOutput.output(doc, (Writer)writer);
                writer.close();
            }
        }
        catch (IOException io) {
            System.out.println(io.getMessage());
        }
    }
}

